/* ============ */
/* getgcd.c	*/
/* ============ */
#include <defcodes.h>
#include <math.h>
/* ==================================================================== */
/* GetGCD - finds greatest common divisor by Euclid's algorithn		*/
/* ==================================================================== */
LDBL
GetGCD(LDBL  m, LDBL  n)
{
    LDBL  t;

    m = floorl(fabsl(m)), n = floorl(fabsl(n));

   if (m < n)
   {
	t = m; m = n; n = t;
    }
    while (n > 0)
    {
	t = fmodl(m, n);
	m = n, n = t;
    }

    return (m);
}
# undef TEST
# ifdef TEST
#define	MAIN	main
#define	GETLDBL GetLDBL
#include <miscdefs.h>
void
MAIN()
{
    LDBL u, v;

    printf("Testing Euclid's algorithm:  "
	   "Needs two integers per call\n\n");

    while (main)
    {
	GETLDBL("Enter first of the next pair: ", &u);
	GETLDBL("Enter the second:             ", &v);

	printf("GCD = %.Lf\n", GetGCD(u,v));
    }
}
# endif
